#import "PXPaletteController.h"
#import "SubviewTableViewCell.h"
#import "PXColorWell.h"
#import "PXMatrix.h"

@implementation PXPaletteController

- (void)applicationDidFinishLaunching:notification
{
	id prototype = [[SubviewTableViewCell alloc] init];
	id well = [[PXColorWell alloc] initWithFrame:NSMakeRect(0, 0, 32, 32)];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(colorWellSelected:) name:@"PXColorWellSelected" object:nil];
	[well setBordered:NO];
	[prototype addSubview:well];
	matrix = [[PXMatrix alloc] initWithFrame:NSMakeRect(0, -32*64, 330, 32*64+64) mode:NSRadioModeMatrix prototype:prototype numberOfRows:64 numberOfColumns:10];
	[matrix setSelectionByRect:NO];
	[matrix setBackgroundColor:[NSColor blackColor]];
	[matrix setCellBackgroundColor:[NSColor blackColor]];
	[matrix setAutosizesCells:YES];
	[matrix setAutoresizingMask:NSViewMinYMargin];
	[matrix setAutosizesCells:NO];
	[splitView replaceSubview:dummyView with:matrix];
//	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(splitViewFrameDidChange:) name:NSViewFrameDidChangeNotification object:splitView];
//	[splitView setPostsFrameChangedNotifications:YES];
}

- (void)splitViewDidResizeSubviews:notification
{
	unsigned int mask = [splitView autoresizingMask];
	[splitView setAutoresizingMask:NSViewNotSizable];
	NSRect frame = [[self window] frame];
	[[self window] setFrame:NSMakeRect(frame.origin.x, frame.origin.y - 1, frame.size.width, frame.size.height+1) display:NO];
	[splitView setAutoresizingMask:mask];	
	[splitView adjustSubviews];
}

- (float)splitView:(NSSplitView *)sender constrainSplitPosition:(float)proposedPosition ofSubviewAt:(int)offset
{
	return [sender frame].size.height;
}

- (void)splitView:(NSSplitView *)sender resizeSubviewsWithOldSize:(NSSize)oldSize
{
	//[[[splitView subviews] objectAtIndex:1] setFrameSize:NSMakeSize([splitView frame].size.width, 0)];
	//[splitView adjustSubviews];
}

- (void)windowDidResize:aNotification
{
	[splitView setNeedsDisplay:YES];
}

- (void)keyDown:(NSEvent *)event
{
	int column, row = 0;
	NSString * chars = [[event characters] lowercaseString];
	if([[NSScanner scannerWithString:chars] scanInt:&column])
	{
		//these are broken for shift1, shift2, etc due to !, @, and so on
		if([event modifierFlags] == NSShiftKeyMask)
		{
			row = 1;
		}
		if([event modifierFlags] == (NSShiftKeyMask | NSAlternateKeyMask))
		{
			row = 2;
		}
		if([event modifierFlags] == NSControlKeyMask)
		{
			//right mouse
			row = 0;
		}
		if([event modifierFlags] == (NSControlKeyMask | NSShiftKeyMask))
		{
			//right mouse
			row = 1;
		}
		if([event modifierFlags] == (NSControlKeyMask | NSShiftKeyMask | NSAlternateKeyMask))
		{
			//right mouse
			row = 2;
		}
		column--;
		if(column < 0) { column = 9; }
		[matrix selectCellAtRow:row column:column];
	}
}

- (void)colorWellSelected:aNotification
{
	[[NSNotificationCenter defaultCenter] postNotificationName:@"PXPaletteColorChosen" object:self userInfo:[NSDictionary dictionaryWithObjectsAndKeys:[[aNotification object] color], @"color", [NSNumber numberWithBool:NSPointInRect([[NSApp currentEvent] locationInWindow], [[[aNotification object] superview] convertRect:[[aNotification object] frame] toView:nil])], @"shouldActivate", nil]];
}

@end
